/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RSA {
    private final PrivateKey privateKey;
    private final PublicKey ownPublicKey;
    private PublicKey counterPublicKey;

    public RSA() throws Exception {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
        gen.initialize(2048);
        KeyPair pair = gen.generateKeyPair();
        this.privateKey = pair.getPrivate();
        this.ownPublicKey = pair.getPublic();
    }

    private RSA(PrivateKey priv, PublicKey pub) {
        this.privateKey = priv;
        this.ownPublicKey = pub;
    }

    public void setPublicKey(PublicKey key) {
        this.counterPublicKey = key;
    }

    public void setPublicKeyBase64(String base64Key) throws Exception {
        this.counterPublicKey = RSA.decodePublicKey(base64Key);
    }

    public PublicKey getPublicKey() {
        return this.ownPublicKey;
    }

    public String getPublicKeyBase64() {
        return Base64.getEncoder().encodeToString(this.ownPublicKey.getEncoded());
    }

    public byte[] encrypt(byte[] data) throws Exception {
        this.checkCounterKey();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, this.counterPublicKey);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] encrypted) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, this.privateKey);
        return cipher.doFinal(encrypted);
    }

    public String encrypt(String data) throws Exception {
        return Base64.getEncoder().encodeToString(this.encrypt(data.getBytes(StandardCharsets.UTF_8)));
    }

    public String decrypt(String base64Data) throws Exception {
        return new String(this.decrypt(Base64.getDecoder().decode(base64Data)), StandardCharsets.UTF_8);
    }

    public byte[] sign(byte[] data) throws Exception {
        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initSign(this.privateKey);
        sig.update(data);
        return sig.sign();
    }

    public boolean verify(byte[] data, byte[] signatureBytes) throws Exception {
        this.checkCounterKey();
        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initVerify(this.counterPublicKey);
        sig.update(data);
        return sig.verify(signatureBytes);
    }

    public String sign(String data) throws Exception {
        return Base64.getEncoder().encodeToString(this.sign(data.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean verify(String data, String base64Signature) throws Exception {
        return this.verify(data.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(base64Signature));
    }

    private static PublicKey decodePublicKey(String base64Key) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(base64Key)));
    }

    public static RSA fromBase64(String pubBase64, String privBase64) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey pub = factory.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(pubBase64)));
        PrivateKey priv = factory.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privBase64)));
        return new RSA(priv, pub);
    }

    private void checkCounterKey() {
        if (this.counterPublicKey == null) {
            throw new IllegalStateException("Counter public key not set");
        }
    }
}

