/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public final class AudioMixers {
    private AudioMixers() {
    }

    public static Mixer.Info findPlaybackMixer(AudioFormat fmt) {
        for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
            Mixer m = AudioSystem.getMixer(mi);
            if (m.getSourceLineInfo().length == 0) continue;
            if (m.isLineSupported(new DataLine.Info(SourceDataLine.class, fmt))) {
                return mi;
            }
            if (!m.isLineSupported(new DataLine.Info(SourceDataLine.class, null))) continue;
            return mi;
        }
        return null;
    }

    public static void dumpMixers() {
        System.out.println("=== Mixers ===");
        for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
            Mixer m = AudioSystem.getMixer(mi);
            System.out.printf("- %s (%s)%n", mi.getName(), mi.getDescription());
            Line.Info[] src = m.getSourceLineInfo(new Line.Info(SourceDataLine.class));
            System.out.println("  SourceDataLine: " + src.length);
        }
    }
}

