/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public final class MicCollector
implements AutoCloseable,
Runnable {
    public static final int FRAME_MS = 50;
    private AudioFormat fmt = new AudioFormat(48000.0f, 16, 1, true, false);
    private final TargetDataLine mic;
    private final BlockingQueue<byte[]> out;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread thread;
    private int frameBytes;

    public MicCollector(BlockingQueue<byte[]> out, Mixer.Info inputDevice, AudioFormat fmt) throws LineUnavailableException {
        this.out = out;
        this.fmt = fmt;
        this.frameBytes = (int)(fmt.getSampleRate() * 0.05f) * fmt.getFrameSize();
        TargetDataLine line = (TargetDataLine)AudioSystem.getMixer(inputDevice).getLine(new DataLine.Info(TargetDataLine.class, null));
        int openBuf = Math.max(this.frameBytes, 4096);
        line.open(fmt, openBuf);
        this.mic = line;
    }

    public MicCollector(BlockingQueue<byte[]> out, Mixer.Info inputDevice) throws LineUnavailableException {
        this(out, inputDevice, new AudioFormat(48000.0f, 16, 1, true, false));
    }

    public MicCollector(BlockingQueue<byte[]> out) throws LineUnavailableException {
        this(out, AudioSystem.getMixerInfo()[0], new AudioFormat(48000.0f, 16, 1, true, false));
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.mic.start();
            this.thread = new Thread((Runnable)this, "MicCollector");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        byte[] frame = new byte[this.frameBytes];
        while (this.running.get()) {
            int n;
            for (int off = 0; off < this.frameBytes && this.running.get() && (n = this.mic.read(frame, off, this.frameBytes - off)) >= 0; off += n) {
            }
            if (!this.running.get()) break;
            try {
                this.out.put(Arrays.copyOf(frame, frame.length));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @Override
    public void close() {
        this.running.set(false);
        try {
            this.mic.stop();
            this.mic.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

